
const {Job, User} = require('../models/index')
exports.createJob = async (req, res) => {
    const {
        client_name,
        phone,
        email,
        job_cost,
        address,
        postcode,
        service_required,
        assigned_to,
        assigned_by,
        description

    } = req.body;
    try {
        // const 
        const job = await Job.create({
            client_name:client_name,
            phone:phone,
            email:email,
            address:address,
            job_cost:job_cost,
            postcode:postcode,
            service_required:service_required,
            assigned_to:assigned_to,
            assigned_by:assigned_by,
            message:description
        })
        res.status(201).json({ success: true, message: 'Job created successfully', job });
    } catch (err) {
        res.status(500).json({ success: false, message: 'Error creating job', error: err.message });
    }
};
exports.fetchJobs = async (req, res) => {
    const {status }= req.params;
   
    try {
        // const 
        let job = [];
        if(status == 'all'){
             job = await Job.findAll({
                include:[
                    {
                        model:User,
                        as:'assignedBy',
                        attributes:["id","name"]
                    },
                    {
                        model:User,
                        as:'assignedTo',
                        attributes:["id","name"]
                    }
                ]
             });
            }else{
                
                job = await Job.findAll({
                    where:{
                        status: status
                    },
                    include:[
                        {
                            model:User,
                            as:'assignedBy',
                            attributes:["id","name"]
                        },
                        {
                            model:User,
                            as:'assignedTo',
                            attributes:["id","name"]
                        }
                    ]
                });
        }
        res.status(200).json({ success: true, message: 'success', job });
    } catch (err) {
        res.status(500).json({ success: false, message: 'Error creating job', error: err.message });
    }
};
exports.singleJobFetch = async (req,res)=>{
    const {id} = req.params;
    try {
        const job = await Job.findOne({
            where:{
                id: id
            },
            include:[
                {
                    model:User,
                    as:'assignedBy',
                    attributes:["id","name"]
                },
                {
                    model:User,
                    as:'assignedTo',
                    attributes:["id","name"]
                }
            ]
        });
        if(!job){
            res.status(500).json({ success: false, message: 'Error creating job'});    
        }
        res.status(200).json({  message: 'success', job });
    } catch (err) {
        res.status(500).json({ success: false, message: 'Error creating job', error: err.message });
    }
}

