const {User} = require('../models')
const bcrypt = require('bcrypt')


exports.createUser = async (req,res)=>{
    console.log(req.body)
    const {
        name,
        email, 
        password,
        role, 
        phone
    } = req.body;
    try {
        const hashedPassword = await bcrypt.hash(password, 10);
        const user = User.create({
            name, 
            email,
            password:hashedPassword,
            phone,
            role
        });
        
        res.status(201).json({message:'successfully added the user',user});
    } catch (error) {
        res.status(500).json({message:error.message});
    }

}
exports.loginUser = async (req, res) => {
    console.log(req.body)
    const { email, password } = req.body;
    try {
      const user = await User.findOne({ where: { email } });
  
      if (!user) {
        return res.status(401).json({ message: 'Invalid email or password' });
      }
  
      // Check password
      const isMatch = await bcrypt.compare(password, user.password);
  
      if (!isMatch) {
        return res.status(401).json({ message: 'Invalid email or password' });
      }
  
      // Respond with success (you can add token generation logic here if needed)
      res.status(200).json({
        message: 'Login successful',
        data:user,
      });
    } catch (error) {
      res.status(500).json({ error: error.message });
    }
  };
exports.fetchElectrician = async (req, res) => {
    
    try {
     const user = await User.findAll({
        where: {
            role : 'electrician'
        }
     });
     
      res.status(200).json({
        message: 'success',
        data:user,
      });
    } catch (error) {
      res.status(500).json({ error: error.message });
    }
  };
exports.fetchUsers = async (req, res) => {
    
    try {
     const user = await User.findAll();
     
      res.status(200).json({
        message: 'success',
        data:user,
      });
    } catch (error) {
      res.status(500).json({ error: error.message });
    }
  };