const sequelize = require('../config/db');
const User = require('../models/userModel');
const Job = require('../models/jobModel');

// Job belongs to User
Job.belongsTo(User, { foreignKey: { name: 'assigned_by', allowNull: true }, as: 'assignedBy' });
Job.belongsTo(User, { foreignKey: { name: 'assigned_to', allowNull: true }, as: 'assignedTo' });
User.hasMany(Job, { foreignKey: 'assigned_by', as: 'jobsAssignedBy' });
User.hasMany(Job, { foreignKey: 'assigned_to', as: 'jobsAssignedTo' });

module.exports = {
  sequelize,
  Job,
  User,
};
