const { DataTypes } = require('sequelize');
const sequelize = require('../config/db'); // Adjust path as necessary
const User = require('./userModel');

const Job = sequelize.define(
  'Job',
  {
    client_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    phone: {
      type: DataTypes.STRING,
      allowNull: false,
      unique: true,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    address: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    job_cost: {
      type: DataTypes.FLOAT,
      allowNull: false,
      defaultValue: 0.0,
    },
    postcode: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    service_required: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    assigned_to: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    assigned_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    message: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      defaultValue: 'new',
    },
  },
  {
    timestamps: true,
    tableName: 'jobs',
  }
);

module.exports = Job;
