// models/User.js

const { DataTypes } = require('sequelize');
const sequelize = require('../config/db'); // Adjust path as necessary

const User = sequelize.define('Users', {
  name: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  email: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
  },
  password: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  phone: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  role: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  status: {
    type: DataTypes.STRING,
    allowNull: true,
    defaultValue: 'active', // Default status is 'active'
  },
}, {
  timestamps: true, // Automatically adds createdAt and updatedAt
  tableName: 'users', // Table name in the database 
});

module.exports = User;
