const express = require('express');
const app = express();
const jobRoutes = require('./routes/jobRoutes');
const userRoutes = require('./routes/userRoutes');
const db = require('./config/db');
const bodyParser = require('body-parser')
const sequelize = require('./config/db')
const cors = require('cors')
// Middleware
app.use(express.json());
app.use(bodyParser.json());
app.use(cors())
// Routes
app.use('/api/job', jobRoutes);
app.use('/api/user', userRoutes);

// Start server
const PORT = process.env.PORT || 5001;
const startServer = async () => {
    try {
      await sequelize.sync(); // Sync models with the database
  
      // Set auto-increment starting values
      
      await sequelize.query('ALTER TABLE users AUTO_INCREMENT = 1100');
      await sequelize.query('ALTER TABLE jobs AUTO_INCREMENT = 2100');
  
      app.listen(PORT, () => {
        console.log(`Server is running on http://localhost:${PORT}`);
      });
    } catch (error) {
      console.error('Unable to connect to the database:', error);
    }
};
startServer();
